function no_spots = calc_spot_numbers(thresScore, no_ori, no_ter)
% Calculate number of spots in each cell after generateSpotsforDist.m
% assumes fluo1 - ori, fluo2 - ter, fluo3 - MukBEF

% spot parameters
thresSigma = [0.7 1.1];     % width of the spot parameter in superSegger
if nargin < 1
    thresScore = 3;         % score of the spot parameter in superSegger
elseif nargin < 3
    thresScore = 3;         % score of the spot parameter in superSegger
    no_ori = 1:4;           % number of ori
    no_ter = 1:4;           % number of ter
end

[filename,pathname] = uigetfile('*.mat', 'Select images to segment','MultiSelect', 'on');

% if a single file loaded
if ~iscell(filename)
    name = filename;
    filename = cell(1);
    filename{1} = name;
end

percent_cells_no_spots = zeros(1,length(filename));
cell_numbers = zeros(1,length(filename));
for kk = 1:length(filename)
    load([ pathname filename{kk} ]);

    scores = [];
    no_spots = [];
    fitSigma = [];
    for ii = 1:length(spots)
        % cell has spots in all channels
        if ~isempty(spots(ii).fluo3) && ~isempty(spots(ii).fluo2) && ...
                ~isempty(spots(ii).fluo1) && ...
                ~isempty(spots(ii).fluo3.l) && ~isempty(spots(ii).fluo2.l) && ...
                ~isempty(spots(ii).fluo1.l)
            scores = [scores spots(ii).fluo3.score];
            fitSigma = [fitSigma spots(ii).fluo3.sigma];
            mask_spots = spots(ii).fluo3.score > thresScore & ...
                spots(ii).fluo3.sigma > thresSigma(1) & ...
                spots(ii).fluo3.sigma < thresSigma(2);
            % cell has enough spots with criteria
            % and specific number of ori/ter spots
            if sum(mask_spots) > 0 && sum(length(spots(ii).fluo1.l) == no_ori) > 0 ...
                    && sum(length(spots(ii).fluo2.l) == no_ter)
                no_spots = [no_spots length(spots(ii).fluo3.l(mask_spots))];
            elseif sum(length(spots(ii).fluo1.l) == no_ori) > 0 ...
                    && sum(length(spots(ii).fluo2.l) == no_ter)
                no_spots = [no_spots 0];
            end
        % only ori and ter spots (cells without are ignored)        
        elseif ~isempty(spots(ii).fluo1) && ~isempty(spots(ii).fluo2) ...
                && ~isempty(spots(ii).fluo1.l) && ~isempty(spots(ii).fluo2.l)
            no_spots = [no_spots 0];
        end 
    end
    fprintf('\n');
    fraction = sum(no_spots>0)./(length(no_spots));
    percent_cells_no_spots(kk) = fraction.*100;
    cell_numbers(kk) = length(no_spots);
    disp(['# results ' num2str(kk) ' #'])
    disp(['Selected number of ori: ' num2str(no_ori)])
    disp(['Selected number of ter: ' num2str(no_ter)])
    disp(['Cells with spots: ' num2str(fraction.*100) '%'])
    disp(['Number of cells: ' num2str((length(no_spots)))])
end
if length(filename) > 1
    fprintf('\n');
    disp('#Combined results#')
    disp(['Selected number of ori: ' num2str(no_ori)])
    disp(['Selected number of ter: ' num2str(no_ter)])
    disp(['Mean of repeats: ' num2str(mean(percent_cells_no_spots)) '%'])
    disp(['Standard deviation of repeats: ' num2str(std(percent_cells_no_spots)) '%'])
    disp(['SEM of repeats: ' num2str(std(percent_cells_no_spots)./sqrt(length(filename))) '%'])
    disp(['Total number of cells: ' num2str(sum(cell_numbers))])
    fprintf('\n');
end
end

